"use client";

import { useRef } from "react";
import Link from "next/link";
import Image from "next/image";
import gsap from "gsap";
import { ScrollTrigger } from "gsap/ScrollTrigger";
import { useGSAP } from "@gsap/react";
import { useTheme } from "@/contexts/ThemeContext";

gsap.registerPlugin(ScrollTrigger, useGSAP);

export default function Testimonials() {
    const sectionRef = useRef<HTMLElement>(null);
    const contentRef = useRef<HTMLDivElement>(null);
    const { theme } = useTheme();

    useGSAP(
        () => {
            const cards = contentRef.current?.querySelectorAll(".testimonial-card");
            if (!cards) return;

            gsap.fromTo(
                cards,
                {
                    opacity: 0,
                    y: 40,
                },
                {
                    opacity: 1,
                    y: 0,
                    duration: 1,
                    stagger: 0.2,
                    ease: "power2.out",
                    scrollTrigger: {
                        trigger: sectionRef.current,
                        start: "top 75%",
                        toggleActions: "play none none reverse",
                    },
                }
            );
        },
        { scope: sectionRef }
    );

    return (
        <section
            id="testimonials"
            ref={sectionRef}
            className="section"
            style={{
                paddingTop: "var(--space-5xl)",
                paddingBottom: "var(--space-5xl)",
            }}
        >
            <div className="container">
                <div
                    className="testimonial-parent-card animated-gradient-card"
                    style={{
                        borderRadius: "var(--radius-lg)",
                        padding: "var(--space-4xl)",
                        position: "relative",
                        overflow: "hidden",
                    }}
                >
                    {/* Corner Borders */}
                    <div className="corner-borders"></div>

                    {/* Header */}
                    <div style={{ textAlign: "center", marginBottom: "var(--space-4xl)" }}>
                        <h2 className="heading-xl" style={{ marginBottom: "var(--space-md)" }}>
                            What Our Clients Say
                        </h2>
                        <p className="body-lg" style={{ maxWidth: "60ch", margin: "0 auto", opacity: 0.7 }}>
                            Trusted by hospitals, government bodies, and enterprises to build their most critical systems.
                        </p>
                    </div>

                    {/* Grid Layout */}
                    <div
                        ref={contentRef}
                        style={{
                            display: "grid",
                            gridTemplateColumns: "repeat(12, 1fr)",
                            gap: "var(--space-xl)",
                            maxWidth: "1400px",
                            margin: "0 auto",
                        }}
                        className="testimonial-grid"
                    >
                        {/* Large Card (Left) */}
                        <div
                            className="testimonial-card"
                            style={{
                                gridColumn: "1 / 8",
                                background: "var(--bg-surface)",
                                borderRadius: "var(--radius-lg)",
                                padding: "var(--space-2xl)",
                                border: "1px solid var(--border-subtle)",
                                // color: "var(--text-primary)", // handled by globals
                                display: "flex",
                                flexDirection: "column",
                                gap: "var(--space-xl)",
                                position: "relative",
                            }}
                        >
                            <div className="corner-borders"></div>

                            <div
                                style={{
                                    position: "relative",
                                    width: "100%",
                                    borderRadius: "var(--radius-md)",
                                    overflow: "hidden",
                                    aspectRatio: "16/9",
                                    background: "var(--bg-surface-2)",
                                }}
                            >
                                <Image
                                    src="https://images.unsplash.com/photo-1579684385127-1ef15d508118?w=800&q=80"
                                    alt="Hospital and healthcare management - modern healthcare infrastructure"
                                    fill
                                    sizes="(max-width: 1024px) 100vw, 50vw"
                                    style={{ objectFit: "cover" }}
                                />
                            </div>

                            <div>
                                <p className="body-lg" style={{ marginBottom: "var(--space-md)", lineHeight: 1.6 }}>
                                    &quot;Sanvya has revolutionized our hospital operations.&quot;
                                </p>
                                <p className="body-md" style={{ marginBottom: "var(--space-sm)", lineHeight: 1.6, opacity: 0.9 }}>
                                    Patient management is seamless; staff efficiency has increased significantly.
                                </p>
                                <p className="body-md" style={{ marginBottom: "var(--space-sm)", lineHeight: 1.6, opacity: 0.9 }}>
                                    The integrated billing system alone saves us hours every day.
                                </p>
                                <p className="body-md" style={{ marginBottom: "var(--space-sm)", lineHeight: 1.6, opacity: 0.9 }}>
                                    OPD to IPD, lab to pharmacy—everything on one platform. The complete healthcare infrastructure we needed.
                                </p>
                                <p className="body-md" style={{ marginBottom: "var(--space-lg)", lineHeight: 1.6, opacity: 0.9 }}>
                                    Reporting and compliance are straightforward; we have a single source of truth across all departments.
                                </p>

                                <div style={{ display: "flex", alignItems: "center", gap: "var(--space-md)" }}>
                                    <div style={{ fontWeight: 700, color: "var(--text-primary)" }}>RM</div>
                                    <div style={{ fontSize: "0.9rem", fontWeight: 500, opacity: 0.8 }}>Dr. Rajesh Mehta, Hospital Administrator — Multi-Speciality Hospital</div>
                                </div>
                            </div>
                        </div>

                        {/* Right Column Grid */}
                        <div
                            style={{
                                gridColumn: "8 / 13",
                                display: "flex",
                                flexDirection: "column",
                                gap: "var(--space-xl)",
                            }}
                            className="testimonial-column-right"
                        >
                            {/* Smaller Card 1 */}
                            <div
                                className="testimonial-card"
                                style={{
                                    background: "var(--bg-surface)",
                                    borderRadius: "var(--radius-lg)",
                                    padding: "var(--space-xl)",
                                    border: "1px solid var(--border-subtle)",
                                    // color: "var(--text-primary)",
                                    flex: 1,
                                    display: "flex",
                                    flexDirection: "column",
                                    justifyContent: "space-between",
                                    position: "relative",
                                }}
                            >
                                <div className="corner-borders"></div>
                                <p className="body-md" style={{ marginBottom: "var(--space-lg)", lineHeight: 1.6 }}>
                                    &quot;The platform has transformed how we deliver citizen services. From application tracking to grievance redressal, everything is now transparent and efficient. Progress for every citizen—exactly what we needed.&quot;
                                </p>
                                <div style={{ display: "flex", alignItems: "center", gap: "var(--space-md)" }}>
                                    <div style={{ width: "32px", height: "32px", borderRadius: "50%", background: "var(--bg-surface-2)", display: "flex", alignItems: "center", justifyContent: "center", fontSize: "0.8rem", fontWeight: 600 }}>AK</div>
                                    <div style={{ fontSize: "0.9rem", fontWeight: 500, opacity: 0.8 }}>Anil Kumar, Nodal Officer — Pragati Services</div>
                                </div>
                            </div>

                            {/* Smaller Cards Row */}
                            <div style={{ display: "flex", gap: "var(--space-xl)", flex: 1 }}>
                                {/* Card 2 */}
                                <div
                                    className="testimonial-card"
                                    style={{
                                        background: "var(--bg-surface)",
                                        borderRadius: "var(--radius-lg)",
                                        padding: "var(--space-xl)",
                                        border: "1px solid var(--border-subtle)",
                                        // color: "var(--text-primary)",
                                        flex: 1,
                                        display: "flex",
                                        flexDirection: "column",
                                        justifyContent: "space-between",
                                        position: "relative",
                                    }}
                                >
                                    <div className="corner-borders"></div>
                                    <p className="body-sm" style={{ marginBottom: "var(--space-md)", lineHeight: 1.6 }}>
                                        &quot;Exceptional support and a system that scaled with our growth. Our OPD and billing workflows are now fully integrated. Highly recommend.&quot;
                                    </p>
                                    <div style={{ display: "flex", alignItems: "center", gap: "var(--space-sm)" }}>
                                        <div style={{ width: "28px", height: "28px", borderRadius: "50%", background: "var(--bg-surface-2)", display: "flex", alignItems: "center", justifyContent: "center", fontSize: "0.7rem", fontWeight: 600 }}>SP</div>
                                        <div style={{ fontSize: "0.8rem", fontWeight: 500, opacity: 0.8 }}>Dr. Sneha Patel, City Care Hospital</div>
                                    </div>
                                </div>

                                {/* Card 3 */}
                                <div
                                    className="testimonial-card"
                                    style={{
                                        background: "var(--bg-surface)",
                                        borderRadius: "var(--radius-lg)",
                                        padding: "var(--space-xl)",
                                        border: "1px solid var(--border-subtle)",
                                        // color: "var(--text-primary)",
                                        flex: 1,
                                        display: "flex",
                                        flexDirection: "column",
                                        justifyContent: "space-between",
                                        position: "relative",
                                    }}
                                >
                                    <div className="corner-borders"></div>
                                    <p className="body-sm" style={{ marginBottom: "var(--space-md)", lineHeight: 1.6 }}>
                                        &quot;We needed a solution that could handle multiple departments and legacy data. The team delivered beyond our expectations.&quot;
                                    </p>
                                    <div style={{ display: "flex", alignItems: "center", gap: "var(--space-sm)" }}>
                                        <div style={{ width: "28px", height: "28px", borderRadius: "50%", background: "var(--bg-surface-2)", display: "flex", alignItems: "center", justifyContent: "center", fontSize: "0.7rem", fontWeight: 600 }}>VS</div>
                                        <div style={{ fontSize: "0.8rem", fontWeight: 500, opacity: 0.8 }}>Vikram Singh, State Health Directorate</div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    {/* Call to Action */}
                    <div style={{ textAlign: "center", marginTop: "var(--space-4xl)", paddingTop: "var(--space-2xl)", borderTop: "1px solid var(--border-subtle)" }}>
                        <h3 className="heading-md" style={{ marginBottom: "var(--space-lg)" }}>
                            Want a custom tailored software for your business?
                        </h3>
                        <Link href="/contact">
                            <button
                                className="btn-primary"
                                style={{
                                    padding: "1rem 2rem",
                                    fontSize: "1.125rem",
                                    background: theme === "dark" ? "#FFFFFF" : "#171717",
                                    color: theme === "dark" ? "#171717" : "#FFFFFF",
                                    cursor: "pointer",
                                    display: "inline-flex",
                                    alignItems: "center",
                                    gap: "var(--space-sm)",
                                }}
                            >
                                Request a custom quote <span>→</span>
                            </button>
                        </Link>
                    </div>
                </div>
            </div>

            <style jsx>{`
                .corner-borders::before,
                .corner-borders::after {
                    content: "";
                    position: absolute;
                    width: 40px;
                    height: 40px;
                    border: 2px solid #171717;
                    transition: border-color 0.3s ease;
                }

                [data-theme="dark"] .corner-borders::before,
                [data-theme="dark"] .corner-borders::after {
                    border-color: #FFFFFF !important;
                }

                .corner-borders::before {
                    top: 0;
                    left: 0;
                    border-right: none;
                    border-bottom: none;
                    border-top-left-radius: var(--radius-lg);
                }

                .corner-borders::after {
                    bottom: 0;
                    right: 0;
                    border-left: none;
                    border-top: none;
                    border-bottom-right-radius: var(--radius-lg);
                }

                .testimonial-card .corner-borders::before,
                .testimonial-card .corner-borders::after {
                    width: 20px; 
                    height: 20px;
                    border-width: 1px;
                    border-color: var(--border-subtle);
                }
                 
                [data-theme="dark"] .testimonial-card .corner-borders::before,
                [data-theme="dark"] .testimonial-card .corner-borders::after {
                    border-color: rgba(255, 255, 255, 0.4) !important;
                }

                .testimonial-parent-card {
                    transition: transform 0.3s ease, box-shadow 0.3s ease;
                }

                .testimonial-parent-card:hover {
                    transform: translateY(-4px);
                    box-shadow: 0 12px 32px rgba(0, 0, 0, 0.08);
                }

                @media (max-width: 1024px) {
                    .testimonial-grid {
                        display: flex !important;
                        flex-direction: column !important;
                    }
                    
                    .testimonial-card, .testimonial-column-right {
                        grid-column: auto !important;
                        width: 100% !important;
                    }
                }

                @media (max-width: 767px) {
                    .corner-borders::before,
                    .corner-borders::after {
                        width: 30px;
                        height: 30px;
                    }
                }
            `}</style>
        </section >
    );
}
