"use client";

import { useEffect, useState } from "react";
import Image from "next/image";
import { useTheme } from "@/contexts/ThemeContext";

export default function Navbar() {
    const [isScrolled, setIsScrolled] = useState(false);
    const [isMobileMenuOpen, setIsMobileMenuOpen] = useState(false);
    const { theme, toggleTheme } = useTheme();

    useEffect(() => {
        const handleScroll = () => {
            const scrollThreshold = 100; // 100px scroll trigger
            setIsScrolled(window.scrollY > scrollThreshold);
        };

        window.addEventListener("scroll", handleScroll, { passive: true });
        return () => window.removeEventListener("scroll", handleScroll);
    }, []);

    return (
        <>
            <nav
                style={{
                    position: "fixed",
                    top: "var(--space-lg)",
                    left: "50%",
                    transform: "translateX(-50%)",
                    width: isScrolled ? "min(78%, 1100px)" : "min(92%, 1360px)",
                    maxWidth: isScrolled ? "1100px" : "1360px",
                    height: "64px",
                    background: "rgba(255, 255, 255, 0.7)",
                    backdropFilter: "blur(17px)",
                    WebkitBackdropFilter: "blur(17px)",
                    borderRadius: isScrolled ? "var(--radius-full)" : "var(--radius-lg)",
                    border: "1px solid rgba(135, 180, 230, 0.5)",
                    boxShadow: "0 2px 16px rgba(0, 0, 0, 0.04)",
                    transition: "width 350ms ease-out, border-radius 350ms ease-out, max-width 350ms ease-out",
                    zIndex: 1000,
                    display: "flex",
                    alignItems: "center",
                    justifyContent: "space-between",
                    padding: "0 clamp(1rem, 4vw, 3rem)",
                }}
            >
                {/* Logo / Brand */}
                <div
                    style={{
                        display: "flex",
                        alignItems: "center",
                        gap: "0.75rem",
                    }}
                >
                    <Image
                        src={theme === "dark" ? "/Icon-22.png" : "/sanvya-logo.png"}
                        alt="Sanvya"
                        width={48}
                        height={48}
                        style={{
                            display: "block",
                        }}
                    />
                    <span
                        style={{
                            fontSize: "1.5rem",
                            fontWeight: 500,
                            color: "var(--text-primary)",
                            letterSpacing: "-0.01em",
                        }}
                    >
                        Sanvya
                    </span>
                </div>

                {/* Desktop Navigation Links + Theme Toggle */}
                <div
                    style={{
                        display: "flex",
                        gap: "var(--space-md)",
                        alignItems: "center",
                    }}
                    className="desktop-nav"
                >
                    <a
                        href="/"
                        style={{
                            fontSize: "1.3125rem",
                            fontWeight: 400,
                            color: "var(--text-secondary)",
                            textDecoration: "none",
                            transition: "all 0.3s ease",
                            padding: "0.5rem 1rem",
                            borderRadius: "var(--radius-md)",
                        }}
                        onMouseEnter={(e) => {
                            e.currentTarget.style.color = "var(--text-primary)";
                            e.currentTarget.style.background = "rgba(135, 180, 230, 0.2)";
                            e.currentTarget.style.backdropFilter = "blur(10px)";
                        }}
                        onMouseLeave={(e) => {
                            e.currentTarget.style.color = "var(--text-secondary)";
                            e.currentTarget.style.background = "transparent";
                            e.currentTarget.style.backdropFilter = "none";
                        }}
                    >
                        Home
                    </a>
                    <a
                        href="/#services"
                        style={{
                            fontSize: "1.3125rem",
                            fontWeight: 400,
                            color: "var(--text-secondary)",
                            textDecoration: "none",
                            transition: "all 0.3s ease",
                            padding: "0.5rem 1rem",
                            borderRadius: "var(--radius-md)",
                        }}
                        onMouseEnter={(e) => {
                            e.currentTarget.style.color = "var(--text-primary)";
                            e.currentTarget.style.background = "rgba(135, 180, 230, 0.2)";
                            e.currentTarget.style.backdropFilter = "blur(10px)";
                        }}
                        onMouseLeave={(e) => {
                            e.currentTarget.style.color = "var(--text-secondary)";
                            e.currentTarget.style.background = "transparent";
                            e.currentTarget.style.backdropFilter = "none";
                        }}
                    >
                        Services
                    </a>
                    <a
                        href="/#about"
                        style={{
                            fontSize: "1.3125rem",
                            fontWeight: 400,
                            color: "var(--text-secondary)",
                            textDecoration: "none",
                            transition: "all 0.3s ease",
                            padding: "0.5rem 1rem",
                            borderRadius: "var(--radius-md)",
                        }}
                        onMouseEnter={(e) => {
                            e.currentTarget.style.color = "var(--text-primary)";
                            e.currentTarget.style.background = "rgba(135, 180, 230, 0.2)";
                            e.currentTarget.style.backdropFilter = "blur(10px)";
                        }}
                        onMouseLeave={(e) => {
                            e.currentTarget.style.color = "var(--text-secondary)";
                            e.currentTarget.style.background = "transparent";
                            e.currentTarget.style.backdropFilter = "none";
                        }}
                    >
                        About
                    </a>
                    <a
                        href="/#testimonials"
                        style={{
                            fontSize: "1.3125rem",
                            fontWeight: 400,
                            color: "var(--text-secondary)",
                            textDecoration: "none",
                            transition: "all 0.3s ease",
                            padding: "0.5rem 1rem",
                            borderRadius: "var(--radius-md)",
                        }}
                        onMouseEnter={(e) => {
                            e.currentTarget.style.color = "var(--text-primary)";
                            e.currentTarget.style.background = "rgba(135, 180, 230, 0.2)";
                            e.currentTarget.style.backdropFilter = "blur(10px)";
                        }}
                        onMouseLeave={(e) => {
                            e.currentTarget.style.color = "var(--text-secondary)";
                            e.currentTarget.style.background = "transparent";
                            e.currentTarget.style.backdropFilter = "none";
                        }}
                    >
                        Testimonials
                    </a>
                    <a
                        href="/contact"
                        style={{
                            fontSize: "1.3125rem",
                            fontWeight: 400,
                            color: "var(--text-secondary)",
                            textDecoration: "none",
                            transition: "all 0.3s ease",
                            padding: "0.5rem 1rem",
                            borderRadius: "var(--radius-md)",
                        }}
                        onMouseEnter={(e) => {
                            e.currentTarget.style.color = "var(--text-primary)";
                            e.currentTarget.style.background = "rgba(135, 180, 230, 0.2)";
                            e.currentTarget.style.backdropFilter = "blur(10px)";
                        }}
                        onMouseLeave={(e) => {
                            e.currentTarget.style.color = "var(--text-secondary)";
                            e.currentTarget.style.background = "transparent";
                            e.currentTarget.style.backdropFilter = "none";
                        }}
                    >
                        Contact
                    </a>
                    <a
                        href="/team"
                        style={{
                            fontSize: "1.3125rem",
                            fontWeight: 400,
                            color: "var(--text-secondary)",
                            textDecoration: "none",
                            transition: "all 0.3s ease",
                            padding: "0.5rem 1rem",
                            borderRadius: "var(--radius-md)",
                        }}
                        onMouseEnter={(e) => {
                            e.currentTarget.style.color = "var(--text-primary)";
                            e.currentTarget.style.background = "rgba(135, 180, 230, 0.2)";
                            e.currentTarget.style.backdropFilter = "blur(10px)";
                        }}
                        onMouseLeave={(e) => {
                            e.currentTarget.style.color = "var(--text-secondary)";
                            e.currentTarget.style.background = "transparent";
                            e.currentTarget.style.backdropFilter = "none";
                        }}
                    >
                        Team
                    </a>

                    {/* Theme Toggle Button */}
                    <button
                        onClick={toggleTheme}
                        style={{
                            background: "none",
                            border: "none",
                            cursor: "pointer",
                            padding: "0.5rem",
                            color: "var(--text-primary)",
                            display: "flex",
                            alignItems: "center",
                            justifyContent: "center",
                            borderRadius: "var(--radius-md)",
                            transition: "all 0.3s ease",
                        }}
                        onMouseEnter={(e) => {
                            e.currentTarget.style.background = "rgba(135, 180, 230, 0.2)";
                            e.currentTarget.style.backdropFilter = "blur(10px)";
                        }}
                        onMouseLeave={(e) => {
                            e.currentTarget.style.background = "transparent";
                            e.currentTarget.style.backdropFilter = "none";
                        }}
                        aria-label="Toggle theme"
                    >
                        {theme === "light" ? (
                            <svg width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" strokeWidth="2" strokeLinecap="round" strokeLinejoin="round">
                                <path d="M21 12.79A9 9 0 1 1 11.21 3 7 7 0 0 0 21 12.79z"></path>
                            </svg>
                        ) : (
                            <svg width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" strokeWidth="2" strokeLinecap="round" strokeLinejoin="round">
                                <circle cx="12" cy="12" r="5"></circle>
                                <line x1="12" y1="1" x2="12" y2="3"></line>
                                <line x1="12" y1="21" x2="12" y2="23"></line>
                                <line x1="4.22" y1="4.22" x2="5.64" y2="5.64"></line>
                                <line x1="18.36" y1="18.36" x2="19.78" y2="19.78"></line>
                                <line x1="1" y1="12" x2="3" y2="12"></line>
                                <line x1="21" y1="12" x2="23" y2="12"></line>
                                <line x1="4.22" y1="19.78" x2="5.64" y2="18.36"></line>
                                <line x1="18.36" y1="5.64" x2="19.78" y2="4.22"></line>
                            </svg>
                        )}
                    </button>
                </div>

                {/* Mobile Menu Button */}
                <button
                    onClick={() => setIsMobileMenuOpen(!isMobileMenuOpen)}
                    style={{
                        display: "none",
                        background: "none",
                        border: "none",
                        cursor: "pointer",
                        padding: "0.5rem",
                        color: "var(--text-primary)",
                    }}
                    className="mobile-menu-btn"
                    aria-label="Toggle menu"
                >
                    <svg width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" strokeWidth="2">
                        {isMobileMenuOpen ? (
                            <path d="M6 18L18 6M6 6l12 12" />
                        ) : (
                            <path d="M3 12h18M3 6h18M3 18h18" />
                        )}
                    </svg>
                </button>
            </nav>

            {/* Mobile Menu Dropdown */}
            {isMobileMenuOpen && (
                <div
                    style={{
                        position: "fixed",
                        top: "calc(var(--space-lg) + 64px + 1rem)",
                        left: "50%",
                        transform: "translateX(-50%)",
                        width: "min(92%, 1360px)",
                        background: "rgba(255, 255, 255, 0.95)",
                        backdropFilter: "blur(17px)",
                        WebkitBackdropFilter: "blur(17px)",
                        borderRadius: "var(--radius-lg)",
                        border: "1px solid rgba(255, 255, 255, 0.3)",
                        boxShadow: "0 4px 24px rgba(0, 0, 0, 0.08)",
                        zIndex: 999,
                        padding: "var(--space-lg)",
                        display: "none",
                    }}
                    className="mobile-menu"
                >
                    <div style={{ display: "flex", flexDirection: "column", gap: "var(--space-md)" }}>
                        <a
                            href="/"
                            onClick={() => setIsMobileMenuOpen(false)}
                            style={{
                                fontSize: "1rem",
                                fontWeight: 400,
                                color: "var(--text-primary)",
                                textDecoration: "none",
                                padding: "var(--space-sm) 0",
                            }}
                        >
                            Home
                        </a>
                        <a
                            href="/#services"
                            onClick={() => setIsMobileMenuOpen(false)}
                            style={{
                                fontSize: "1rem",
                                fontWeight: 400,
                                color: "var(--text-primary)",
                                textDecoration: "none",
                                padding: "var(--space-sm) 0",
                            }}
                        >
                            Services
                        </a>
                        <a
                            href="/#about"
                            onClick={() => setIsMobileMenuOpen(false)}
                            style={{
                                fontSize: "1rem",
                                fontWeight: 400,
                                color: "var(--text-primary)",
                                textDecoration: "none",
                                padding: "var(--space-sm) 0",
                            }}
                        >
                            About
                        </a>
                        <a
                            href="/#testimonials"
                            onClick={() => setIsMobileMenuOpen(false)}
                            style={{
                                fontSize: "1rem",
                                fontWeight: 400,
                                color: "var(--text-primary)",
                                textDecoration: "none",
                                padding: "var(--space-sm) 0",
                            }}
                        >
                            Testimonials
                        </a>
                        <a
                            href="/contact"
                            onClick={() => setIsMobileMenuOpen(false)}
                            style={{
                                fontSize: "1rem",
                                fontWeight: 400,
                                color: "var(--text-primary)",
                                textDecoration: "none",
                                padding: "var(--space-sm) 0",
                            }}
                        >
                            Contact
                        </a>
                        <a
                            href="/team"
                            onClick={() => setIsMobileMenuOpen(false)}
                            style={{
                                fontSize: "1rem",
                                fontWeight: 400,
                                color: "var(--text-primary)",
                                textDecoration: "none",
                                padding: "var(--space-sm) 0",
                            }}
                        >
                            Team
                        </a>
                    </div>
                </div>
            )}

            {/* Mobile Responsive Styles */}
            <style jsx>{`
                @media (max-width: 768px) {
                    .desktop-nav {
                        display: none !important;
                    }
                    .mobile-menu-btn {
                        display: block !important;
                    }
                    .mobile-menu {
                        display: block !important;
                    }
                }
            `}</style>

            {/* EndingSection Mobile Responsive Styles */}
            <style jsx global>{`
                @media (max-width: 767px) {
                    footer .container > div:first-child {
                        flex-direction: column !important;
                        align-items: flex-start !important;
                        gap: var(--space-xl) !important;
                    }

                    footer h1 {
                        font-size: clamp(3rem, 15vw, 6rem) !important;
                    }

                    footer .container > div:last-child {
                        flex-direction: column !important;
                        align-items: flex-start !important;
                        gap: var(--space-md) !important;
                    }
                }
            `}</style>
        </>
    );
}
