"use client";

import { useTheme } from "@/contexts/ThemeContext";

export default function IconRibbon() {
    const { theme } = useTheme();
    // Simple icon symbols matching the reference
    const baseIcons = [
        "◆", // Diamond
        "</>", // Code brackets
        "⚡", // Lightning
        "→", // Arrow
        "◇", // Hollow diamond
        "※", // Reference mark
        "⟨⟩", // Angle brackets
        "⊕", // Circle plus
        "≡", // Menu
        "◉", // Circle dot
        "⬡", // Hexagon
        "▢", // Square
    ];

    // Triple the icons for seamless infinite scroll
    const icons = [...baseIcons, ...baseIcons, ...baseIcons];

    return (
        <div
            style={{
                position: "relative",
                width: "100%",
                padding: "2rem 0",
                overflow: "hidden",
                background: "transparent",
            }}
        >
            {/* Infinite scrolling container */}
            <div
                className="icon-marquee"
                style={{
                    display: "flex",
                    gap: "2rem",
                    animation: "scroll 30s linear infinite",
                    width: "max-content",
                }}
            >
                {icons.map((icon, index) => (
                    <div
                        key={index}
                        style={{
                            width: "82px",
                            height: "82px",
                            borderRadius: "50%",
                            background: theme === "dark" ? "rgba(0, 0, 0, 1)" : "rgba(250, 250, 249, 1)",
                            border: theme === "dark" ? "1px solid rgba(255, 255, 255, 0.2)" : "1px solid rgba(0, 0, 0, 0.08)",
                            display: "flex",
                            alignItems: "center",
                            justifyContent: "center",
                            fontSize: "2.125rem",
                            color: theme === "dark" ? "rgba(255, 255, 255, 0.8)" : "rgba(0, 0, 0, 0.6)",
                            flexShrink: 0,
                            boxShadow: theme === "dark" ? "0 1px 3px rgba(255, 255, 255, 0.05)" : "0 1px 3px rgba(0, 0, 0, 0.05)",
                            transition: "all 0.3s ease",
                        }}
                        className="icon-circle"
                    >
                        {icon}
                    </div>
                ))}
            </div>

            {/* CSS Animations */}
            <style jsx>{`
                @keyframes scroll {
                    0% {
                        transform: translateX(0);
                    }
                    100% {
                        transform: translateX(-50%);
                    }
                }

                .icon-circle:hover {
                    transform: scale(1.15);
                    box-shadow: 0 4px 12px rgba(0, 0, 0, 0.1);
                    background: rgba(255, 255, 255, 1);
                }

                /* Pause on hover */
                .icon-marquee:hover {
                    animation-play-state: paused;
                }

                /* Mobile responsive */
                @media (max-width: 767px) {
                    .icon-circle {
                        width: 68px !important;
                        height: 68px !important;
                        font-size: 1.7rem !important;
                    }
                }
            `}</style>
        </div>
    );
}
