"use client";

import { useState, useRef } from "react";
import Link from "next/link";
import gsap from "gsap";
import { useGSAP } from "@gsap/react";
import AnimatedBackground from "./AnimatedBackground";
import Typewriter from "./Typewriter";
import { useTheme } from "@/contexts/ThemeContext";

gsap.registerPlugin(useGSAP);

export default function Hero() {
    const heroRef = useRef<HTMLElement>(null);
    const contentRef = useRef<HTMLDivElement>(null);
    const [showButtons, setShowButtons] = useState(false);
    const { theme } = useTheme();

    useGSAP(
        () => {
            if (showButtons && contentRef.current) {
                gsap.fromTo(
                    contentRef.current,
                    { opacity: 0, y: 20 },
                    { opacity: 1, y: 0, duration: 0.8, ease: "power2.out" }
                );
            }
        },
        { scope: heroRef, dependencies: [showButtons] }
    );

    return (
        <section
            ref={heroRef}
            className="section"
            style={{
                paddingTop: "var(--space-5xl)",
                paddingBottom: "var(--space-4xl)",
                minHeight: "90vh",
                display: "flex",
                flexDirection: "column",
                justifyContent: "center",
                position: "relative",
                overflow: "hidden",
            }}
        >
            {/* Animated Background */}
            <AnimatedBackground />

            <div className="container" style={{ textAlign: "center", position: "relative", zIndex: 1 }}>
                {/* Wordmark Text */}
                <div style={{ marginBottom: "20px" }}>
                    <span
                        style={{
                            fontSize: "1.125rem",
                            fontWeight: 500,
                            letterSpacing: "0.05em",
                            color: "var(--text-primary)",
                            textTransform: "uppercase",
                        }}
                    >
                        Sanvya Technologies
                    </span>
                </div>

                {/* Typewriter Headline */}
                <Typewriter
                    texts={[
                        { content: "You Imagine,", isHeading: true },
                        { content: "We Engineer.", isHeading: true },
                    ]}
                    speed={80}
                    delay={600}
                    className="display"
                    style={{
                        marginBottom: "var(--space-3xl)",
                        maxWidth: "40ch",
                        margin: "0 auto var(--space-3xl) auto",
                        minHeight: "300px",
                    }}
                    onComplete={() => setShowButtons(true)}
                />
                <div style={{ marginBottom: "20px" }}>
                    <span
                        style={{
                            fontSize: "1.125rem",
                            fontWeight: 500,
                            letterSpacing: "0.01em",
                            color: "var(--text-primary)",
                            textTransform: "uppercase",
                        }}
                    >
                        Backed by <a href="https://www.sanvyahealth.com">Sanvya Health</a>
                    </span>
                </div><br></br>

                {/* CTA Buttons - Show after typewriter completes */}
                {showButtons && (
                    <div
                        ref={contentRef}
                        style={{
                            maxWidth: "540px",
                            margin: "0 auto",
                        }}
                    >
                        <div
                            style={{
                                display: "flex",
                                alignItems: "center",
                                justifyContent: "center",
                            }}
                        >
                            <Link href="/contact">
                                <button
                                    className="btn-primary"
                                    style={{
                                        padding: "1.3125rem 3rem",
                                        fontSize: "1.5rem",
                                        background: theme === "dark" ? "#FFFFFF" : "#171717",
                                        color: theme === "dark" ? "#171717" : "#FFFFFF",
                                        cursor: "pointer",
                                    }}
                                >
                                    Get Started
                                </button>
                            </Link>
                        </div>
                    </div>
                )}
            </div>

            {/* Mobile Responsive Styles */}
            <style jsx>{`
                @media (max-width: 767px) {
                    div[style*="flexWrap"] {
                        justify-content: center;
                        width: 100%;
                    }
                }
            `}</style>
        </section>
    );
}
