"use client";

export default function GridBackground() {
    return (
        <div className="grid-background">
            <style jsx>{`
                .grid-background {
                    position: fixed;
                    top: 0;
                    left: 0;
                    width: 100%;
                    height: 100%;
                    z-index: 0;
                    pointer-events: none;
                    background-image: 
                        linear-gradient(rgba(112, 146, 255, 0.4) 1px, transparent 1px),
                        linear-gradient(90deg, rgba(112, 146, 255, 0.4) 1px, transparent 1px);
                    background-size: 50px 50px;
                    mask-image: 
                        radial-gradient(
                            ellipse 80% 70% at 50% 50%,
                            black 40%,
                            transparent 100%
                        );
                    -webkit-mask-image: 
                        radial-gradient(
                            ellipse 80% 70% at 50% 50%,
                            black 40%,
                            transparent 100%
                        );
                }

                @media (max-width: 767px) {
                    .grid-background {
                        background-size: 30px 30px;
                    }
                }
            `}</style>
        </div>
    );
}
