"use client";

export default function EndingSection() {
    return (
        <footer
            style={{
                position: "relative",
                paddingTop: "var(--space-5xl)",
                paddingBottom: "var(--space-4xl)",
                background: "var(--bg-page)",
                overflow: "hidden",
            }}
        >
            <div className="container">
                {/* UPPER SECTION - Left text + Right link columns */}
                <div
                    style={{
                        display: "flex",
                        justifyContent: "space-between",
                        alignItems: "flex-start",
                        marginBottom: "var(--space-5xl)",
                        flexWrap: "wrap",
                        gap: "var(--space-2xl)",
                    }}
                >
                    {/* Upper Left - Quiet line */}
                    <div style={{ flex: "0 0 auto" }}>
                        <p
                            style={{
                                fontSize: "0.875rem",
                                fontWeight: 300,
                                color: "var(--text-secondary)",
                                letterSpacing: "0.01em",
                            }}
                        >
                            Experience clarity
                        </p>
                    </div>

                    {/* Upper Right - Link columns */}
                    <div
                        style={{
                            display: "flex",
                            gap: "var(--space-2xl)",
                            fontSize: "0.875rem",
                        }}
                    >
                        <div style={{ display: "flex", flexDirection: "column", gap: "var(--space-sm)" }}>
                            <a
                                href="#"
                                style={{
                                    color: "var(--text-secondary)",
                                    textDecoration: "none",
                                    fontWeight: 400,
                                    transition: "color 0.2s",
                                }}
                                onMouseEnter={(e) => (e.currentTarget.style.color = "var(--text-primary)")}
                                onMouseLeave={(e) => (e.currentTarget.style.color = "var(--text-secondary)")}
                            >
                                Work
                            </a>
                            <a
                                href="#"
                                style={{
                                    color: "var(--text-secondary)",
                                    textDecoration: "none",
                                    fontWeight: 400,
                                    transition: "color 0.2s",
                                }}
                                onMouseEnter={(e) => (e.currentTarget.style.color = "var(--text-primary)")}
                                onMouseLeave={(e) => (e.currentTarget.style.color = "var(--text-secondary)")}
                            >
                                About
                            </a>
                            <a
                                href="#"
                                style={{
                                    color: "var(--text-secondary)",
                                    textDecoration: "none",
                                    fontWeight: 400,
                                    transition: "color 0.2s",
                                }}
                                onMouseEnter={(e) => (e.currentTarget.style.color = "var(--text-primary)")}
                                onMouseLeave={(e) => (e.currentTarget.style.color = "var(--text-secondary)")}
                            >
                                Careers
                            </a>
                        </div>
                        <div style={{ display: "flex", flexDirection: "column", gap: "var(--space-sm)" }}>
                            <a
                                href="#"
                                style={{
                                    color: "var(--text-secondary)",
                                    textDecoration: "none",
                                    fontWeight: 400,
                                    transition: "color 0.2s",
                                }}
                                onMouseEnter={(e) => (e.currentTarget.style.color = "var(--text-primary)")}
                                onMouseLeave={(e) => (e.currentTarget.style.color = "var(--text-secondary)")}
                            >
                                Contact
                            </a>
                            <a
                                href="#"
                                style={{
                                    color: "var(--text-secondary)",
                                    textDecoration: "none",
                                    fontWeight: 400,
                                    transition: "color 0.2s",
                                }}
                                onMouseEnter={(e) => (e.currentTarget.style.color = "var(--text-primary)")}
                                onMouseLeave={(e) => (e.currentTarget.style.color = "var(--text-secondary)")}
                            >
                                Blog
                            </a>
                        </div>
                    </div>
                </div>

                {/* CENTER - MASSIVE WORDMARK */}
                <div
                    style={{
                        textAlign: "center",
                        marginBottom: "var(--space-5xl)",
                        paddingTop: "var(--space-3xl)",
                        paddingBottom: "var(--space-3xl)",
                        width: "100%",
                        overflow: "hidden",
                    }}
                >
                    <h1
                        className="ending-wordmark"
                        style={{
                            fontSize: "clamp(4rem, 20vw, 18rem)",
                            fontWeight: 700,
                            letterSpacing: "-0.04em",
                            lineHeight: 0.9,
                            color: "var(--text-primary)",
                            margin: 0,
                            padding: "0 0.5rem",
                            wordBreak: "keep-all",
                            whiteSpace: "nowrap",
                        }}
                    >
                        Sanvya
                    </h1>
                </div>

                {/* Wordmark Responsive Styles */}
                <style jsx>{`
                    @media (max-width: 767px) {
                        .ending-wordmark {
                            font-size: clamp(3rem, 22vw, 6rem) !important;
                            letter-spacing: -0.03em !important;
                        }
                    }

                    @media (min-width: 768px) and (max-width: 1200px) {
                        .ending-wordmark {
                            font-size: clamp(6rem, 16vw, 12rem) !important;
                        }
                    }

                    @media (min-width: 1201px) {
                        .ending-wordmark {
                            font-size: clamp(10rem, 18vw, 18rem) !important;
                        }
                    }
                `}</style>

                {/* BOTTOM SECTION - Left label + Right inline links */}
                <div
                    style={{
                        display: "flex",
                        justifyContent: "space-between",
                        alignItems: "center",
                        flexWrap: "wrap",
                        gap: "var(--space-lg)",
                    }}
                >
                    {/* Bottom Left - Subtle label */}
                    <div>
                        <span
                            style={{
                                fontSize: "0.75rem",
                                fontWeight: 400,
                                color: "var(--text-tertiary)",
                                letterSpacing: "0.05em",
                            }}
                        >
                            Sanvya Technologies
                        </span>
                    </div>

                    {/* Bottom Right - Inline legal/social links */}
                    <div
                        style={{
                            display: "flex",
                            gap: "var(--space-lg)",
                            fontSize: "0.75rem",
                        }}
                    >
                        <a
                            href="#"
                            style={{
                                color: "var(--text-tertiary)",
                                textDecoration: "none",
                                transition: "color 0.2s",
                            }}
                            onMouseEnter={(e) => (e.currentTarget.style.color = "var(--text-primary)")}
                            onMouseLeave={(e) => (e.currentTarget.style.color = "var(--text-tertiary)")}
                        >
                            Privacy
                        </a>
                        <a
                            href="#"
                            style={{
                                color: "var(--text-tertiary)",
                                textDecoration: "none",
                                transition: "color 0.2s",
                            }}
                            onMouseEnter={(e) => (e.currentTarget.style.color = "var(--text-primary)")}
                            onMouseLeave={(e) => (e.currentTarget.style.color = "var(--text-tertiary)")}
                        >
                            Terms
                        </a>
                        <a
                            href="#"
                            style={{
                                color: "var(--text-tertiary)",
                                textDecoration: "none",
                                transition: "color 0.2s",
                            }}
                            onMouseEnter={(e) => (e.currentTarget.style.color = "var(--text-primary)")}
                            onMouseLeave={(e) => (e.currentTarget.style.color = "var(--text-tertiary)")}
                        >
                            LinkedIn
                        </a>
                        <a
                            href="#"
                            style={{
                                color: "var(--text-tertiary)",
                                textDecoration: "none",
                                transition: "color 0.2s",
                            }}
                            onMouseEnter={(e) => (e.currentTarget.style.color = "var(--text-primary)")}
                            onMouseLeave={(e) => (e.currentTarget.style.color = "var(--text-tertiary)")}
                        >
                            Twitter
                        </a>
                    </div>
                </div>
            </div>
        </footer>
    );
}
