"use client";

import Navbar from "@/components/Navbar";
import EndingSection from "@/components/EndingSection";

interface TeamMember {
    name: string;
    role: string;
    image: string; // Placeholder or actual image path
    linkedin: string;
}

const teamMembers: TeamMember[] = [
    {
        name: "Uttam Vagashiya",
        role: "CEO & Founder",
        image: "/placeholder-team-1.jpg",
        linkedin: "https://www.linkedin.com/in/uttamkumarvaghasiya/",
    },
    {
        name: "Bisesh Kasera",
        role: "CSO & Founder",
        image: "/placeholder-team-2.jpg",
        linkedin: "https://www.linkedin.com/in/bishesh-kasera-305408233/",
    },
    {
        name: "Pratham Debnath",
        role: "CTO & Co-Founder",
        image: "/placeholder-team-3.jpg",
        linkedin: "https://www.linkedin.com/in/pratham-debnath-894471314/",
    },
];

export default function TeamPage() {
    return (
        <main style={{ background: "var(--bg-page)", minHeight: "100vh" }}>
            {/* NAVBAR */}
            <Navbar />

            {/* TEAM HERO SECTION */}
            <section
                className="section"
                style={{
                    paddingTop: "calc(var(--space-5xl) + 64px)",
                    paddingBottom: "var(--space-5xl)",
                }}
            >
                <div className="container" style={{ textAlign: "center" }}>
                    <h1
                        className="display"
                        style={{
                            marginBottom: "var(--space-2xl)",
                            maxWidth: "20ch",
                            margin: "0 auto var(--space-2xl) auto",
                        }}
                    >
                        Meet the Core Team
                    </h1>

                    <p
                        className="body-lg"
                        style={{
                            maxWidth: "40ch",
                            margin: "0 auto var(--space-5xl)",
                            opacity: 0.85,
                        }}
                    >
                        The minds behind Sanvya Technologies.
                    </p>

                    {/* Team Grid */}
                    <div
                        style={{
                            display: "grid",
                            gridTemplateColumns: "repeat(auto-fit, minmax(300px, 1fr))",
                            gap: "var(--space-3xl)",
                            maxWidth: "1200px",
                            margin: "0 auto",
                        }}
                    >
                        {teamMembers.map((member, index) => (
                            <div
                                key={index}
                                className="team-card animated-gradient-card"
                                style={{
                                    borderRadius: "var(--radius-lg)",
                                    padding: "var(--space-2xl)",
                                    position: "relative",
                                    overflow: "hidden",
                                    textAlign: "center",
                                    display: "flex",
                                    flexDirection: "column",
                                    alignItems: "center",
                                }}
                            >
                                {/* Corner Borders */}
                                <div className="corner-borders"></div>

                                {/* Image Placeholder */}
                                <div
                                    style={{
                                        width: "150px",
                                        height: "150px",
                                        borderRadius: "50%",
                                        background: "var(--bg-surface-2)",
                                        marginBottom: "var(--space-lg)",
                                        overflow: "hidden",
                                        display: "flex",
                                        alignItems: "center",
                                        justifyContent: "center",
                                        border: "2px solid var(--border-subtle)",
                                    }}
                                >
                                    <span style={{ fontSize: "3rem", opacity: 0.5 }}>👤</span>
                                </div>

                                <h3 className="heading-md" style={{ marginBottom: "var(--space-sm)" }}>
                                    {member.name}
                                </h3>
                                <p className="body" style={{ color: "var(--text-secondary)", marginBottom: "var(--space-md)" }}>
                                    {member.role}
                                </p>

                                <a
                                    href={member.linkedin}
                                    target="_blank"
                                    rel="noopener noreferrer"
                                    style={{
                                        color: "var(--text-secondary)",
                                        transition: "all 0.2s ease",
                                        display: "inline-flex",
                                        alignItems: "center",
                                        justifyContent: "center",
                                        textDecoration: "none",
                                        padding: "8px",
                                        borderRadius: "50%",
                                    }}
                                    onMouseEnter={(e) => {
                                        e.currentTarget.style.color = "#0077b5";
                                        e.currentTarget.style.background = "rgba(0, 119, 181, 0.1)";
                                    }}
                                    onMouseLeave={(e) => {
                                        e.currentTarget.style.color = "var(--text-secondary)";
                                        e.currentTarget.style.background = "transparent";
                                    }}
                                    aria-label={`LinkedIn profile of ${member.name}`}
                                >
                                    <svg width="24" height="24" viewBox="0 0 24 24" fill="currentColor">
                                        <path d="M19 0h-14c-2.761 0-5 2.239-5 5v14c0 2.761 2.239 5 5 5h14c2.762 0 5-2.239 5-5v-14c0-2.761-2.238-5-5-5zm-11 19h-3v-11h3v11zm-1.5-12.268c-.966 0-1.75-.79-1.75-1.764s.784-1.764 1.75-1.764 1.75.79 1.75 1.764-.783 1.764-1.75 1.764zm13.5 12.268h-3v-5.604c0-3.368-4-3.113-4 0v5.604h-3v-11h3v1.765c1.396-2.586 7-2.777 7 2.476v6.759z" />
                                    </svg>
                                </a>
                            </div>
                        ))}
                    </div>
                </div>

                {/* Corner Border Styles */}
                <style jsx>{`
                    .corner-borders::before,
                    .corner-borders::after {
                        content: "";
                        position: absolute;
                        width: 40px;
                        height: 40px;
                        border: 2px solid #171717;
                        transition: all 0.3s ease;
                    }

                    [data-theme="dark"] .corner-borders::before,
                    [data-theme="dark"] .corner-borders::after {
                        border-color: #FFFFFF !important;
                    }

                    .corner-borders::before {
                        top: 0;
                        left: 0;
                        border-right: none;
                        border-bottom: none;
                        border-top-left-radius: var(--radius-lg);
                    }

                    .corner-borders::after {
                        bottom: 0;
                        right: 0;
                        border-left: none;
                        border-top: none;
                        border-bottom-right-radius: var(--radius-lg);
                    }

                    .team-card {
                        transition: transform 0.3s ease, box-shadow 0.3s ease;
                        background: var(--bg-surface);
                    }

                    .team-card:hover {
                        transform: translateY(-4px);
                        box-shadow: 0 12px 32px rgba(0, 0, 0, 0.08);
                    }
                `}</style>
            </section>

            {/* ENDING SECTION */}
            <EndingSection />
        </main>
    );
}
